/*
 * No-copyright
 * A table of numbers, generated by a script, is supposedly not copyrightable.
 */

static int os_socket_pf(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef PF_UNIX
		case 1: return PF_UNIX;
#endif
#ifdef PF_INET
		case 2: return PF_INET;
#endif
#ifdef PF_AX25
		case 3: return PF_AX25;
#endif
#ifdef PF_IPX
		case 4: return PF_IPX;
#endif
#ifdef PF_APPLETALK
		case 5: return PF_APPLETALK;
#endif
#ifdef PF_NETROM
		case 6: return PF_NETROM;
#endif
#ifdef PF_BRIDGE
		case 7: return PF_BRIDGE;
#endif
#ifdef PF_ATMPVC
		case 8: return PF_ATMPVC;
#endif
#ifdef PF_X25
		case 9: return PF_X25;
#endif
#ifdef PF_INET6
		case 10: return PF_INET6;
#endif
#ifdef PF_ROSE
		case 11: return PF_ROSE;
#endif
#ifdef PF_DECnet
		case 12: return PF_DECnet;
#endif
#ifdef PF_NETBEUI
		case 13: return PF_NETBEUI;
#endif
#ifdef PF_SECURITY
		case 14: return PF_SECURITY;
#endif
#ifdef PF_KEY
		case 15: return PF_KEY;
#endif
#ifdef PF_NETLINK
		case 16: return PF_NETLINK;
#endif
#ifdef PF_PACKET
		case 17: return PF_PACKET;
#endif
#ifdef PF_ASH
		case 18: return PF_ASH;
#endif
#ifdef PF_ECONET
		case 19: return PF_ECONET;
#endif
#ifdef PF_ATMSVC
		case 20: return PF_ATMSVC;
#endif
#ifdef PF_RDS
		case 21: return PF_RDS;
#endif
#ifdef PF_SNA
		case 22: return PF_SNA;
#endif
#ifdef PF_IRDA
		case 23: return PF_IRDA;
#endif
#ifdef PF_PPPOX
		case 24: return PF_PPPOX;
#endif
#ifdef PF_WANPIPE
		case 25: return PF_WANPIPE;
#endif
#ifdef PF_LLC
		case 26: return PF_LLC;
#endif
#ifdef PF_IB
		case 27: return PF_IB;
#endif
#ifdef PF_MPLS
		case 28: return PF_MPLS;
#endif
#ifdef PF_CAN
		case 29: return PF_CAN;
#endif
#ifdef PF_TIPC
		case 30: return PF_TIPC;
#endif
#ifdef PF_BLUETOOTH
		case 31: return PF_BLUETOOTH;
#endif
#ifdef PF_IUCV
		case 32: return PF_IUCV;
#endif
#ifdef PF_RXRPC
		case 33: return PF_RXRPC;
#endif
#ifdef PF_ISDN
		case 34: return PF_ISDN;
#endif
#ifdef PF_PHONET
		case 35: return PF_PHONET;
#endif
#ifdef PF_IEEE802154
		case 36: return PF_IEEE802154;
#endif
#ifdef PF_CAIF
		case 37: return PF_CAIF;
#endif
#ifdef PF_ALG
		case 38: return PF_ALG;
#endif
#ifdef PF_NFC
		case 39: return PF_NFC;
#endif
#ifdef PF_VSOCK
		case 40: return PF_VSOCK;
#endif
#ifdef PF_KCM
		case 41: return PF_KCM;
#endif
#ifdef PF_QIPCRTR
		case 42: return PF_QIPCRTR;
#endif
#ifdef PF_SMC
		case 43: return PF_SMC;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

static int os_socket_af(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef AF_UNIX
		case 1: return AF_UNIX;
#endif
#ifdef AF_INET
		case 2: return AF_INET;
#endif
#ifdef AF_AX25
		case 3: return AF_AX25;
#endif
#ifdef AF_IPX
		case 4: return AF_IPX;
#endif
#ifdef AF_APPLETALK
		case 5: return AF_APPLETALK;
#endif
#ifdef AF_NETROM
		case 6: return AF_NETROM;
#endif
#ifdef AF_BRIDGE
		case 7: return AF_BRIDGE;
#endif
#ifdef AF_ATMPVC
		case 8: return AF_ATMPVC;
#endif
#ifdef AF_X25
		case 9: return AF_X25;
#endif
#ifdef AF_INET6
		case 10: return AF_INET6;
#endif
#ifdef AF_ROSE
		case 11: return AF_ROSE;
#endif
#ifdef AF_DECnet
		case 12: return AF_DECnet;
#endif
#ifdef AF_NETBEUI
		case 13: return AF_NETBEUI;
#endif
#ifdef AF_SECURITY
		case 14: return AF_SECURITY;
#endif
#ifdef AF_KEY
		case 15: return AF_KEY;
#endif
#ifdef AF_NETLINK
		case 16: return AF_NETLINK;
#endif
#ifdef AF_PACKET
		case 17: return AF_PACKET;
#endif
#ifdef AF_ASH
		case 18: return AF_ASH;
#endif
#ifdef AF_ECONET
		case 19: return AF_ECONET;
#endif
#ifdef AF_ATMSVC
		case 20: return AF_ATMSVC;
#endif
#ifdef AF_RDS
		case 21: return AF_RDS;
#endif
#ifdef AF_SNA
		case 22: return AF_SNA;
#endif
#ifdef AF_IRDA
		case 23: return AF_IRDA;
#endif
#ifdef AF_PPPOX
		case 24: return AF_PPPOX;
#endif
#ifdef AF_WANPIPE
		case 25: return AF_WANPIPE;
#endif
#ifdef AF_LLC
		case 26: return AF_LLC;
#endif
#ifdef AF_IB
		case 27: return AF_IB;
#endif
#ifdef AF_MPLS
		case 28: return AF_MPLS;
#endif
#ifdef AF_CAN
		case 29: return AF_CAN;
#endif
#ifdef AF_TIPC
		case 30: return AF_TIPC;
#endif
#ifdef AF_BLUETOOTH
		case 31: return AF_BLUETOOTH;
#endif
#ifdef AF_IUCV
		case 32: return AF_IUCV;
#endif
#ifdef AF_RXRPC
		case 33: return AF_RXRPC;
#endif
#ifdef AF_ISDN
		case 34: return AF_ISDN;
#endif
#ifdef AF_PHONET
		case 35: return AF_PHONET;
#endif
#ifdef AF_IEEE802154
		case 36: return AF_IEEE802154;
#endif
#ifdef AF_CAIF
		case 37: return AF_CAIF;
#endif
#ifdef AF_ALG
		case 38: return AF_ALG;
#endif
#ifdef AF_NFC
		case 39: return AF_NFC;
#endif
#ifdef AF_VSOCK
		case 40: return AF_VSOCK;
#endif
#ifdef AF_KCM
		case 41: return AF_KCM;
#endif
#ifdef AF_QIPCRTR
		case 42: return AF_QIPCRTR;
#endif
#ifdef AF_SMC
		case 43: return AF_SMC;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

static int os_af_socket(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef AF_UNIX
		case AF_UNIX: return 1;
#endif
#ifdef AF_INET
		case AF_INET: return 2;
#endif
#ifdef AF_AX25
		case AF_AX25: return 3;
#endif
#ifdef AF_IPX
		case AF_IPX: return 4;
#endif
#ifdef AF_APPLETALK
		case AF_APPLETALK: return 5;
#endif
#ifdef AF_NETROM
		case AF_NETROM: return 6;
#endif
#ifdef AF_BRIDGE
		case AF_BRIDGE: return 7;
#endif
#ifdef AF_ATMPVC
		case AF_ATMPVC: return 8;
#endif
#ifdef AF_X25
		case AF_X25: return 9;
#endif
#ifdef AF_INET6
		case AF_INET6: return 10;
#endif
#ifdef AF_ROSE
		case AF_ROSE: return 11;
#endif
#ifdef AF_DECnet
		case AF_DECnet: return 12;
#endif
#ifdef AF_NETBEUI
		case AF_NETBEUI: return 13;
#endif
#ifdef AF_SECURITY
		case AF_SECURITY: return 14;
#endif
#ifdef AF_KEY
		case AF_KEY: return 15;
#endif
#ifdef AF_NETLINK
		case AF_NETLINK: return 16;
#endif
#ifdef AF_PACKET
		case AF_PACKET: return 17;
#endif
#ifdef AF_ASH
		case AF_ASH: return 18;
#endif
#ifdef AF_ECONET
		case AF_ECONET: return 19;
#endif
#ifdef AF_ATMSVC
		case AF_ATMSVC: return 20;
#endif
#ifdef AF_RDS
		case AF_RDS: return 21;
#endif
#ifdef AF_SNA
		case AF_SNA: return 22;
#endif
#ifdef AF_IRDA
		case AF_IRDA: return 23;
#endif
#ifdef AF_PPPOX
		case AF_PPPOX: return 24;
#endif
#ifdef AF_WANPIPE
		case AF_WANPIPE: return 25;
#endif
#ifdef AF_LLC
		case AF_LLC: return 26;
#endif
#ifdef AF_IB
		case AF_IB: return 27;
#endif
#ifdef AF_MPLS
		case AF_MPLS: return 28;
#endif
#ifdef AF_CAN
		case AF_CAN: return 29;
#endif
#ifdef AF_TIPC
		case AF_TIPC: return 30;
#endif
#ifdef AF_BLUETOOTH
		case AF_BLUETOOTH: return 31;
#endif
#ifdef AF_IUCV
		case AF_IUCV: return 32;
#endif
#ifdef AF_RXRPC
		case AF_RXRPC: return 33;
#endif
#ifdef AF_ISDN
		case AF_ISDN: return 34;
#endif
#ifdef AF_PHONET
		case AF_PHONET: return 35;
#endif
#ifdef AF_IEEE802154
		case AF_IEEE802154: return 36;
#endif
#ifdef AF_CAIF
		case AF_CAIF: return 37;
#endif
#ifdef AF_ALG
		case AF_ALG: return 38;
#endif
#ifdef AF_NFC
		case AF_NFC: return 39;
#endif
#ifdef AF_VSOCK
		case AF_VSOCK: return 40;
#endif
#ifdef AF_KCM
		case AF_KCM: return 41;
#endif
#ifdef AF_QIPCRTR
		case AF_QIPCRTR: return 42;
#endif
#ifdef AF_SMC
		case AF_SMC: return 43;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_SYSTEM_RETURNED_INVALID_DATA), err, "invalid value");
			return -1;
	}
}

static int os_socket_type(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef SOCK_STREAM
		case 1: return SOCK_STREAM;
#endif
#ifdef SOCK_DGRAM
		case 2: return SOCK_DGRAM;
#endif
#ifdef SOCK_SEQPACKET
		case 3: return SOCK_SEQPACKET;
#endif
#ifdef SOCK_RAW
		case 4: return SOCK_RAW;
#endif
#ifdef SOCK_RDM
		case 5: return SOCK_RDM;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

static int os_socket_msg(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef MSG_OOB
		case 1: return MSG_OOB;
#endif
#ifdef MSG_PEEK
		case 2: return MSG_PEEK;
#endif
#ifdef MSG_DONTROUTE
		case 4: return MSG_DONTROUTE;
#endif
#ifdef MSG_DONTWAIT
		case 8: return MSG_DONTWAIT;
#endif
#ifdef MSG_EOR
		case 16: return MSG_EOR;
#endif
#ifdef MSG_CONFIRM
		case 32: return MSG_CONFIRM;
#endif
#ifdef MSG_ERRQUEUE
		case 64: return MSG_ERRQUEUE;
#endif
#ifdef MSG_MORE
		case 128: return MSG_MORE;
#endif
#ifdef MSG_BATCH
		case 256: return MSG_BATCH;
#endif
#ifdef MSG_FASTOPEN
		case 512: return MSG_FASTOPEN;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

static int os_socket_level(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef SOL_SOCKET
		case 1: return SOL_SOCKET;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

static int os_socket_option(int idx, ajla_error_t *err)
{
	switch (idx) {
#ifdef SO_DEBUG
		case 1: return SO_DEBUG;
#endif
#ifdef SO_REUSEADDR
		case 2: return SO_REUSEADDR;
#endif
#ifdef SO_TYPE
		case 3: return SO_TYPE;
#endif
#ifdef SO_ERROR
		case 4: return SO_ERROR;
#endif
#ifdef SO_DONTROUTE
		case 5: return SO_DONTROUTE;
#endif
#ifdef SO_BROADCAST
		case 6: return SO_BROADCAST;
#endif
#ifdef SO_SNDBUF
		case 7: return SO_SNDBUF;
#endif
#ifdef SO_RCVBUF
		case 8: return SO_RCVBUF;
#endif
#ifdef SO_KEEPALIVE
		case 9: return SO_KEEPALIVE;
#endif
#ifdef SO_OOBINLINE
		case 10: return SO_OOBINLINE;
#endif
#ifdef SO_NO_CHECK
		case 11: return SO_NO_CHECK;
#endif
#ifdef SO_PRIORITY
		case 12: return SO_PRIORITY;
#endif
#ifdef SO_LINGER
		case 13: return SO_LINGER;
#endif
#ifdef SO_BSDCOMPAT
		case 14: return SO_BSDCOMPAT;
#endif
#ifdef SO_REUSEPORT
		case 15: return SO_REUSEPORT;
#endif
#ifdef SO_PASSCRED
		case 16: return SO_PASSCRED;
#endif
#ifdef SO_PEERCRED
		case 17: return SO_PEERCRED;
#endif
#ifdef SO_RCVLOWAT
		case 18: return SO_RCVLOWAT;
#endif
#ifdef SO_SNDLOWAT
		case 19: return SO_SNDLOWAT;
#endif
#ifdef SO_RCVTIMEO
		case 20: return SO_RCVTIMEO;
#endif
#ifdef SO_SNDTIMEO
		case 21: return SO_SNDTIMEO;
#endif
#ifdef SO_SECURITY_AUTHENTICATION
		case 22: return SO_SECURITY_AUTHENTICATION;
#endif
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
		case 23: return SO_SECURITY_ENCRYPTION_TRANSPORT;
#endif
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
		case 24: return SO_SECURITY_ENCRYPTION_NETWORK;
#endif
#ifdef SO_BINDTODEVICE
		case 25: return SO_BINDTODEVICE;
#endif
#ifdef SO_ATTACH_FILTER
		case 26: return SO_ATTACH_FILTER;
#endif
#ifdef SO_DETACH_FILTER
		case 27: return SO_DETACH_FILTER;
#endif
#ifdef SO_PEERNAME
		case 28: return SO_PEERNAME;
#endif
#ifdef SO_TIMESTAMP
		case 29: return SO_TIMESTAMP;
#endif
#ifdef SO_ACCEPTCONN
		case 30: return SO_ACCEPTCONN;
#endif
#ifdef SO_PEERSEC
		case 31: return SO_PEERSEC;
#endif
#ifdef SO_SNDBUFFORCE
		case 32: return SO_SNDBUFFORCE;
#endif
#ifdef SO_RCVBUFFORCE
		case 33: return SO_RCVBUFFORCE;
#endif
#ifdef SO_PASSSEC
		case 34: return SO_PASSSEC;
#endif
#ifdef SO_TIMESTAMPNS
		case 35: return SO_TIMESTAMPNS;
#endif
#ifdef SO_MARK
		case 36: return SO_MARK;
#endif
#ifdef SO_TIMESTAMPING
		case 37: return SO_TIMESTAMPING;
#endif
#ifdef SO_PROTOCOL
		case 38: return SO_PROTOCOL;
#endif
#ifdef SO_DOMAIN
		case 39: return SO_DOMAIN;
#endif
#ifdef SO_RXQ_OVFL
		case 40: return SO_RXQ_OVFL;
#endif
#ifdef SO_WIFI_STATUS
		case 41: return SO_WIFI_STATUS;
#endif
#ifdef SO_PEEK_OFF
		case 42: return SO_PEEK_OFF;
#endif
#ifdef SO_NOFCS
		case 43: return SO_NOFCS;
#endif
#ifdef SO_LOCK_FILTER
		case 44: return SO_LOCK_FILTER;
#endif
#ifdef SO_SELECT_ERR_QUEUE
		case 45: return SO_SELECT_ERR_QUEUE;
#endif
#ifdef SO_BUSY_POLL
		case 46: return SO_BUSY_POLL;
#endif
#ifdef SO_MAX_PACING_RATE
		case 47: return SO_MAX_PACING_RATE;
#endif
#ifdef SO_BPF_EXTENSIONS
		case 48: return SO_BPF_EXTENSIONS;
#endif
#ifdef SO_INCOMING_CPU
		case 49: return SO_INCOMING_CPU;
#endif
#ifdef SO_ATTACH_BPF
		case 50: return SO_ATTACH_BPF;
#endif
#ifdef SO_ATTACH_REUSEPORT_CBPF
		case 51: return SO_ATTACH_REUSEPORT_CBPF;
#endif
#ifdef SO_ATTACH_REUSEPORT_EBPF
		case 52: return SO_ATTACH_REUSEPORT_EBPF;
#endif
#ifdef SO_CNX_ADVICE
		case 53: return SO_CNX_ADVICE;
#endif
#ifdef SCM_TIMESTAMPING_OPT_STATS
		case 54: return SCM_TIMESTAMPING_OPT_STATS;
#endif
#ifdef SO_MEMINFO
		case 55: return SO_MEMINFO;
#endif
#ifdef SO_INCOMING_NAPI_ID
		case 56: return SO_INCOMING_NAPI_ID;
#endif
#ifdef SO_COOKIE
		case 57: return SO_COOKIE;
#endif
#ifdef SCM_TIMESTAMPING_PKTINFO
		case 58: return SCM_TIMESTAMPING_PKTINFO;
#endif
#ifdef SO_PEERGROUPS
		case 59: return SO_PEERGROUPS;
#endif
#ifdef SO_ZEROCOPY
		case 60: return SO_ZEROCOPY;
#endif
#ifdef SO_TXTIME
		case 61: return SO_TXTIME;
#endif
#ifdef SO_BINDTOIFINDEX
		case 62: return SO_BINDTOIFINDEX;
#endif
#ifdef SO_DETACH_REUSEPORT_BPF
		case 63: return SO_DETACH_REUSEPORT_BPF;
#endif
#ifdef SO_PREFER_BUSY_POLL
		case 64: return SO_PREFER_BUSY_POLL;
#endif
#ifdef SO_BUSY_POLL_BUDGET
		case 65: return SO_BUSY_POLL_BUDGET;
#endif
#ifdef SO_NETNS_COOKIE
		case 66: return SO_NETNS_COOKIE;
#endif
		default:
			fatal_mayfail(error_ajla(EC_SYNC, AJLA_ERROR_INVALID_OPERATION), err, "invalid value");
			return -1;
	}
}

