/*
 * Copyright (C) 2024 Mikulas Patocka
 *
 * This file is part of Ajla.
 *
 * Ajla is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ajla is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * Ajla. If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <limits.h>

#include "widechar_width.h"

#define class_combining		-1
#define class_zero		0
#define class_one		1
#define class_two		2

static int char_class(int c)
{
	int w = widechar_wcwidth(c);
	switch (w) {
		case 1: 			return class_one;
		case 2:				return class_two;
		case widechar_nonprint:		return class_zero;
		case widechar_combining:	return class_combining;
		case widechar_ambiguous:	return class_one;
		case widechar_private_use:	return class_one;
		case widechar_unassigned:	return class_one;
		case widechar_widened_in_9:	return class_two;
		case widechar_non_character:	return class_zero;
		default:			abort();

	}
}

int main(void)
{
	int i;
	int last_cls;
	printf("{*\n");
	printf(" * No-copyright\n");
	printf(" * A table of numbers, generated by a script, is supposedly not copyrightable.\n");
	printf(" *}\n");
	printf("\n");
	printf("private unit uni_table;\n");
	printf("\n");
	printf("const uni_table~cache : (r : list(char), contract len(r) >= 2);\n");
	printf("\n");
	printf("implementation\n");
	printf("\n");
	printf("const uni_table~cache : (r : list(char), contract len(r) >= 2) := list(char).[\n");
	last_cls = INT_MAX;
	for (i = 0; i < 0x110000; i++) {
		int cls = char_class(i);
		if (cls != last_cls) {
			printf("\t#%x, %d,\n", i, cls);
			last_cls = cls;
		}
	}
	if (last_cls != class_zero)
		printf("\t#%x, %d,\n", i, class_zero);
	printf("];\n");
	return 0;
}
